/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.registry;

import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.block.ChairBlock;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;
import satisfyu.candlelight.Candlelight;
import satisfyu.candlelight.block.BigTableBlock;
import satisfyu.candlelight.block.BoardBlock;
import satisfyu.candlelight.block.ChocolateBoxBlock;
import satisfyu.candlelight.block.CookingPanBlock;
import satisfyu.candlelight.block.CookingPotBlock;
import satisfyu.candlelight.block.DecorationBlock;
import satisfyu.candlelight.block.EffectFoodBlock;
import satisfyu.candlelight.block.EffectFoodTrayBlock;
import satisfyu.candlelight.block.FacingBlock;
import satisfyu.candlelight.block.JewelryBoxBlock;
import satisfyu.candlelight.block.KitchenSinkBlock;
import satisfyu.candlelight.block.LanternBlock;
import satisfyu.candlelight.block.LineConnectingBlock;
import satisfyu.candlelight.block.PizzaBlock;
import satisfyu.candlelight.block.RoseBushBlock;
import satisfyu.candlelight.block.ShelfBlock;
import satisfyu.candlelight.block.SideBoardBlock;
import satisfyu.candlelight.block.SideTableBlock;
import satisfyu.candlelight.block.SmallPaintingBlock;
import satisfyu.candlelight.block.SofaBlock;
import satisfyu.candlelight.block.StorageBlock;
import satisfyu.candlelight.block.StoveBlock;
import satisfyu.candlelight.block.TableBlock;
import satisfyu.candlelight.block.TableSetBlock;
import satisfyu.candlelight.block.ToolRackBlock;
import satisfyu.candlelight.block.TypeWriterBlock;
import satisfyu.candlelight.block.crops.BroccoliCropBlock;
import satisfyu.candlelight.block.crops.TomatoCropBlock;
import satisfyu.candlelight.block.crops.WildBushTomato;
import satisfyu.candlelight.food.CandlelightFoods;
import satisfyu.candlelight.food.EffectFoodBlockItem;
import satisfyu.candlelight.item.ClosedLetterItem;
import satisfyu.candlelight.item.CookDefaultArmorItem;
import satisfyu.candlelight.item.CookingHatItem;
import satisfyu.candlelight.item.CookingPanItem;
import satisfyu.candlelight.item.IngredientItem;
import satisfyu.candlelight.item.LetterItem;
import satisfyu.candlelight.item.RingItem;
import satisfyu.candlelight.item.TableSetItem;
import satisfyu.candlelight.item.WriteablePaperItem;
import satisfyu.candlelight.item.WrittenPaperItem;
import satisfyu.candlelight.item.food.EffectFoodItem;
import satisfyu.candlelight.registry.ArmorMaterialRegistry;
import satisfyu.candlelight.registry.SoundEventsRegistry;
import satisfyu.candlelight.util.CandlelightIdentifier;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"candlelight", (ResourceKey)Registry.f_122904_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"candlelight", (ResourceKey)Registry.f_122901_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> BROCCOLI_CROP = ObjectRegistry.registerWithoutItem("broccoli_crop", () -> new BroccoliCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_)));
    public static final RegistrySupplier<Block> TOMATO_CROP = ObjectRegistry.registerWithoutItem("tomato_crop", () -> new TomatoCropBlock(ObjectRegistry.getBushSettings()));
    public static final RegistrySupplier<Item> TOMATO_SEEDS = ObjectRegistry.registerItem("tomato_seeds", () -> new BlockItem((Block)TOMATO_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> TOMATO = ObjectRegistry.registerItem("tomato", () -> new IngredientItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38810_)));
    public static final RegistrySupplier<Item> BROCCOLI_SEEDS = ObjectRegistry.registerItem("broccoli_seeds", () -> new BlockItem((Block)BROCCOLI_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> BROCCOLI = ObjectRegistry.registerItem("broccoli", () -> new IngredientItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38799_)));
    public static final RegistrySupplier<Block> TOMATO_CRATE = ObjectRegistry.registerWithItem("tomato_crate", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> BROCCOLI_CRATE = ObjectRegistry.registerWithItem("broccoli_crate", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> CARROT_CRATE = ObjectRegistry.registerWithItem("carrot_crate", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> POTATO_CRATE = ObjectRegistry.registerWithItem("potato_crate", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> BEETROOT_CRATE = ObjectRegistry.registerWithItem("beetroot_crate", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> TOMATOES_WILD = ObjectRegistry.registerWithoutItem("tomatoes_wild", () -> new WildBushTomato(ObjectRegistry.getBushSettings()));
    public static final RegistrySupplier<Block> WILD_BROCCOLI = ObjectRegistry.registerWithoutItem("wild_broccoli", () -> new FlowerBlock(MobEffects.f_19611_, 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_)));
    public static final RegistrySupplier<Block> FLOORBOARD = ObjectRegistry.registerWithItem("floorboard", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> DRAWER = ObjectRegistry.registerWithItem("drawer", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventsRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> CABINET = ObjectRegistry.registerWithItem("cabinet", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventsRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> SIDEBOARD = ObjectRegistry.registerWithItem("sideboard", () -> new SideBoardBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> CHAIR = ObjectRegistry.registerWithItem("chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> SOFA = ObjectRegistry.registerWithItem("sofa", () -> new SofaBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> TABLE = ObjectRegistry.registerWithItem("table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> LAMP = ObjectRegistry.registerWithItem("lamp", () -> new LanternBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_).m_60953_(s -> (Boolean)s.m_61143_((Property)LanternBlock.LUMINANCE) != false ? 15 : 0).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> SIDE_TABLE = ObjectRegistry.registerWithItem("side_table", () -> new SideTableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> COOKING_POT = ObjectRegistry.registerWithItem("cooking_pot", () -> new CookingPotBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60955_()));
    public static final RegistrySupplier<Block> COOKING_PAN = ObjectRegistry.registerWithoutItem("cooking_pan", () -> new CookingPanBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistrySupplier<Item> COOKING_PAN_ITEM = ObjectRegistry.registerItem("cooking_pan", () -> new CookingPanItem((Block)COOKING_PAN.get(), ObjectRegistry.getSettings(), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get()));
    public static final RegistrySupplier<Block> TABLE_SET = ObjectRegistry.registerWithItem("table_set", () -> new TableSetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)COOKING_POT.get()))));
    public static final RegistrySupplier<Item> GLASS = ObjectRegistry.registerItem("glass", () -> new TableSetItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> NAPKIN = ObjectRegistry.registerItem("napkin", () -> new TableSetItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> BUTTER = ObjectRegistry.registerItem("butter", () -> new IngredientItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> MOZZARELLA = ObjectRegistry.registerItem("mozzarella", () -> new IngredientItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38815_)));
    public static final RegistrySupplier<Item> DOUGH = ObjectRegistry.registerItem("dough", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> PASTA_RAW = ObjectRegistry.registerItem("pasta_raw", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> TOMATO_SOUP = ObjectRegistry.registerItem("tomato_soup", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.TOMATO_SOUP), 1));
    public static final RegistrySupplier<Item> MUSHROOM_SOUP = ObjectRegistry.registerItem("mushroom_soup", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.MUSHROOM_SOUP), 1));
    public static final RegistrySupplier<Item> BEETROOT_SALAD = ObjectRegistry.registerItem("beetroot_salad", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38811_)));
    public static final RegistrySupplier<Item> PASTA = ObjectRegistry.registerItem("pasta", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.PASTA), 2));
    public static final RegistrySupplier<Item> BOLOGNESE = ObjectRegistry.registerItem("bolognese", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.BOLOGNESE), 1));
    public static final RegistrySupplier<Item> CHICKEN_TERIYAKI = ObjectRegistry.registerItem("chicken_teriyaki", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38820_)));
    public static final RegistrySupplier<Item> BROCCOLI_SALAD = ObjectRegistry.registerItem("broccoli_salad", () -> new Item(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.BROCCOLI_SALAD)));
    public static final RegistrySupplier<Item> BEEF_TARTARE = ObjectRegistry.registerItem("beef_tartare", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38820_)));
    public static final RegistrySupplier<Item> COOKED_BEEF = ObjectRegistry.registerItem("cooked_beef", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.COOKED_BEEF), 2));
    public static final RegistrySupplier<Item> CHICKEN_ALFREDO = ObjectRegistry.registerItem("chicken_alfredo", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.VEGGIE_PLATE), 1));
    public static final RegistrySupplier<Item> BROCCOLI_BEEF = ObjectRegistry.registerItem("broccoli_beef", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.BROCCOLI_BEEF), 2));
    public static final RegistrySupplier<Block> BROCCOLI_TOMATO_BLOCK = ObjectRegistry.registerWithoutItem("broccoli_tomato_block", () -> new EffectFoodTrayBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 2, CandlelightFoods.BROCCOLI_TOMATO));
    public static final RegistrySupplier<Item> BROCCOLI_TOMATO = ObjectRegistry.registerItem("broccoli_tomato", () -> new EffectFoodBlockItem((Block)BROCCOLI_TOMATO_BLOCK.get(), ObjectRegistry.getSettings().m_41489_(CandlelightFoods.BROCCOLI_TOMATO), 3));
    public static final RegistrySupplier<Item> SALMON_WINE = ObjectRegistry.registerItem("salmon_wine", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.SALMON_ON_WHITE_WINE), 2));
    public static final RegistrySupplier<Item> VEGGIE_PLATE = ObjectRegistry.registerItem("veggie_plate", () -> new Item(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.VEGGIE_PLATE)));
    public static final RegistrySupplier<Block> PORK_RIBS_BLOCK = ObjectRegistry.registerWithoutItem("pork_ribs_block", () -> new EffectFoodBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 2, CandlelightFoods.PORK_RIBS));
    public static final RegistrySupplier<Item> PORK_RIBS = ObjectRegistry.registerItem("pork_ribs", () -> new EffectFoodBlockItem((Block)PORK_RIBS_BLOCK.get(), ObjectRegistry.getSettings().m_41489_(CandlelightFoods.PORK_RIBS), 2));
    public static final RegistrySupplier<Item> PASTA_BOLOGNESE = ObjectRegistry.registerItem("pasta_bolognese", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.VEGGIE_PLATE), 1));
    public static final RegistrySupplier<Item> PASTA_BROCCOLI = ObjectRegistry.registerItem("pasta_broccoli", () -> new Item(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.TOMATO_MOZZARELLA_SALAD)));
    public static final RegistrySupplier<Item> PANCAKE = ObjectRegistry.registerItem("pancake", () -> new Item(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.FRICASSE)));
    public static final RegistrySupplier<Item> FRICASSE = ObjectRegistry.registerItem("fricasse", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.FRICASSE), 2));
    public static final RegistrySupplier<Item> CHICKEN = ObjectRegistry.registerItem("chicken", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38831_), 2));
    public static final RegistrySupplier<Block> TOMATO_MOZZARELLA_BLOCK = ObjectRegistry.registerWithoutItem("tomato_mozzarella_block", () -> new EffectFoodTrayBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 2, CandlelightFoods.TOMATO_MOZZARELLA_SALAD));
    public static final RegistrySupplier<Item> TOMATO_MOZZARELLA_SALAD = ObjectRegistry.registerItem("tomato_mozzarella_salad", () -> new EffectFoodBlockItem((Block)TOMATO_MOZZARELLA_BLOCK.get(), ObjectRegistry.getSettings().m_41489_(CandlelightFoods.TOMATO_MOZZARELLA_SALAD), 3));
    public static final RegistrySupplier<Block> LASAGNA_BLOCK = ObjectRegistry.registerWithoutItem("lasagne_block", () -> new EffectFoodBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 3, CandlelightFoods.LASAGNE));
    public static final RegistrySupplier<Item> LASAGNA = ObjectRegistry.registerItem("lasagne", () -> new EffectFoodBlockItem((Block)LASAGNA_BLOCK.get(), ObjectRegistry.getSettings().m_41489_(CandlelightFoods.LASAGNE), 3));
    public static final RegistrySupplier<Item> ROASTBEEF_CARROTS = ObjectRegistry.registerItem("roastbeef_carrots", () -> new EffectFoodItem(ObjectRegistry.getSettings().m_41489_(CandlelightFoods.ROASTBEEF_CARROTS), 2));
    public static final RegistrySupplier<Block> BEEF_WELLINGTON_BLOCK = ObjectRegistry.registerWithoutItem("beef_wellington_block", () -> new EffectFoodBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 2, CandlelightFoods.BEEF_WELLINGTON));
    public static final RegistrySupplier<Item> BEEF_WELLINGTON = ObjectRegistry.registerItem("beef_wellington", () -> new EffectFoodBlockItem((Block)BEEF_WELLINGTON_BLOCK.get(), ObjectRegistry.getSettings().m_41489_(CandlelightFoods.BEEF_WELLINGTON), 2));
    public static final RegistrySupplier<Item> PIZZA_SLICE = ObjectRegistry.registerItem("pizza_slice", () -> new Item(ObjectRegistry.getSettings().m_41489_(Foods.f_38811_)));
    public static final RegistrySupplier<Block> PIZZA = ObjectRegistry.registerWithItem("pizza", () -> new PizzaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), PIZZA_SLICE));
    public static final RegistrySupplier<Item> CHOCOLATE = ObjectRegistry.registerItem("chocolate", () -> new IngredientItem(ObjectRegistry.getSettings().m_41489_(Foods.f_38810_)));
    public static final RegistrySupplier<Block> TABLE_SIGN = ObjectRegistry.registerWithItem("table_sign", () -> new BoardBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_), false));
    public static final RegistrySupplier<Block> TOOL_RACK = ObjectRegistry.registerWithItem("tool_rack", () -> new ToolRackBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> PAINTING = ObjectRegistry.registerWithItem("painting", () -> new SmallPaintingBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_()));
    public static final RegistrySupplier<Block> HEARTH = ObjectRegistry.registerWithItem("hearth", () -> new DecorationBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_()));
    public static final RegistrySupplier<Block> ROSE = ObjectRegistry.registerWithItem("rose", () -> new RoseBushBlock(MobEffect.m_19453_((int)6), 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_)));
    public static final RegistrySupplier<Block> JEWELRY_BOX = ObjectRegistry.registerWithItem("jewelry_box", () -> new JewelryBoxBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_)));
    public static final RegistrySupplier<Block> CHOCOLATE_BOX = ObjectRegistry.registerWithItem("chocolate_box", () -> new ChocolateBoxBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_)));
    public static final RegistrySupplier<Item> GOLD_RING = ObjectRegistry.registerItem("gold_ring", () -> new RingItem(ArmorMaterialRegistry.RING_ARMOR, EquipmentSlot.CHEST, ObjectRegistry.getSettings().m_41497_(Rarity.EPIC)));
    public static final RegistrySupplier<Item> COOKING_HAT = ObjectRegistry.registerItem("cooking_hat", () -> new CookingHatItem(ArmorMaterialRegistry.COOK_ARMOR, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> CHEFS_JACKET = ObjectRegistry.registerItem("chefs_jacket", () -> new CookDefaultArmorItem(ArmorMaterialRegistry.COOK_ARMOR, EquipmentSlot.CHEST, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> CHEFS_PANTS = ObjectRegistry.registerItem("chefs_pants", () -> new CookDefaultArmorItem(ArmorMaterialRegistry.COOK_ARMOR, EquipmentSlot.LEGS, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Item> CHEFS_BOOTS = ObjectRegistry.registerItem("chefs_boots", () -> new CookDefaultArmorItem(ArmorMaterialRegistry.COOK_ARMOR, EquipmentSlot.FEET, ObjectRegistry.getSettings().m_41497_(Rarity.COMMON)));
    public static final RegistrySupplier<Block> TYPEWRITER_IRON = ObjectRegistry.registerWithItem("typewriter_iron", () -> new TypeWriterBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistrySupplier<Block> TYPEWRITER_COPPER = ObjectRegistry.registerWithItem("typewriter_copper", () -> new TypeWriterBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistrySupplier<Item> NOTE_PAPER = ObjectRegistry.registerItem("note_paper", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> NOTE_PAPER_WRITEABLE = ObjectRegistry.registerItem("note_paper_writeable", () -> new WriteablePaperItem(ObjectRegistry.getSettings().m_41487_(1)));
    public static final RegistrySupplier<Item> NOTE_PAPER_WRITTEN = ObjectRegistry.registerItem("note_paper_written", () -> new WrittenPaperItem(ObjectRegistry.getSettingsWithoutTab()));
    public static final RegistrySupplier<Item> LETTER_OPEN = ObjectRegistry.registerItem("letter_open", () -> new LetterItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> LETTER_CLOSED = ObjectRegistry.registerItem("letter_closed", () -> new ClosedLetterItem(ObjectRegistry.getSettingsWithoutTab().m_41487_(1)));
    public static final RegistrySupplier<Item> LOVE_LETTER_OPEN = ObjectRegistry.registerItem("love_letter_open", () -> new LetterItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> LOVE_LETTER_CLOSED = ObjectRegistry.registerItem("love_letter", () -> new ClosedLetterItem(ObjectRegistry.getSettingsWithoutTab()));
    public static final RegistrySupplier<Block> COBBLESTONE_STOVE = ObjectRegistry.registerWithItem("cobblestone_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(s -> 12)));
    public static final RegistrySupplier<Block> COBBLESTONE_KITCHEN_SINK = ObjectRegistry.registerWithItem("cobblestone_kitchen_sink", () -> new KitchenSinkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> COBBLESTONE_COUNTER = ObjectRegistry.registerWithItem("cobblestone_counter", () -> new LineConnectingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> OAK_CABINET = ObjectRegistry.registerWithItem("oak_cabinet", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventsRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> OAK_DRAWER = ObjectRegistry.registerWithItem("oak_drawer", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventsRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> OAK_TABLE = ObjectRegistry.registerWithItem("oak_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> OAK_CHAIR = ObjectRegistry.registerWithItem("oak_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> OAK_SHELF = ObjectRegistry.registerWithItem("oak_shelf", () -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> OAK_BIG_TABLE = ObjectRegistry.registerWithItem("oak_big_table", () -> new BigTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 2.0f)));
    public static final RegistrySupplier<Block> SANDSTONE_STOVE = ObjectRegistry.registerWithItem("sandstone_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(s -> 12)));
    public static final RegistrySupplier<Block> SANDSTONE_KITCHEN_SINK = ObjectRegistry.registerWithItem("sandstone_kitchen_sink", () -> new KitchenSinkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> SANDSTONE_COUNTER = ObjectRegistry.registerWithItem("sandstone_counter", () -> new LineConnectingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> BIRCH_CABINET = ObjectRegistry.registerWithItem("birch_cabinet", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventsRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> BIRCH_DRAWER = ObjectRegistry.registerWithItem("birch_drawer", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventsRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> BIRCH_TABLE = ObjectRegistry.registerWithItem("birch_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> BIRCH_CHAIR = ObjectRegistry.registerWithItem("birch_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> BIRCH_SHELF = ObjectRegistry.registerWithItem("birch_shelf", () -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> BIRCH_BIG_TABLE = ObjectRegistry.registerWithItem("birch_big_table", () -> new BigTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 2.0f)));
    public static final RegistrySupplier<Block> STONE_BRICKS_STOVE = ObjectRegistry.registerWithItem("stone_bricks_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(s -> 12)));
    public static final RegistrySupplier<Block> STONE_BRICKS_KITCHEN_SINK = ObjectRegistry.registerWithItem("stone_bricks_kitchen_sink", () -> new KitchenSinkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> STONE_BRICKS_COUNTER = ObjectRegistry.registerWithItem("stone_bricks_counter", () -> new LineConnectingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> SPRUCE_CABINET = ObjectRegistry.registerWithItem("spruce_cabinet", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventsRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> SPRUCE_DRAWER = ObjectRegistry.registerWithItem("spruce_drawer", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventsRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> SPRUCE_TABLE = ObjectRegistry.registerWithItem("spruce_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> SPRUCE_CHAIR = ObjectRegistry.registerWithItem("spruce_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> SPRUCE_SHELF = ObjectRegistry.registerWithItem("spruce_shelf", () -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> SPRUCE_BIG_TABLE = ObjectRegistry.registerWithItem("spruce_big_table", () -> new BigTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 2.0f)));
    public static final RegistrySupplier<Block> DEEPSLATE_STOVE = ObjectRegistry.registerWithItem("deepslate_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(s -> 12)));
    public static final RegistrySupplier<Block> DEEPSLATE_KITCHEN_SINK = ObjectRegistry.registerWithItem("deepslate_kitchen_sink", () -> new KitchenSinkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> DEEPSLATE_COUNTER = ObjectRegistry.registerWithItem("deepslate_counter", () -> new FacingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> DARK_OAK_CABINET = ObjectRegistry.registerWithItem("dark_oak_cabinet", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventsRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> DARK_OAK_DRAWER = ObjectRegistry.registerWithItem("dark_oak_drawer", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventsRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> DARK_OAK_TABLE = ObjectRegistry.registerWithItem("dark_oak_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_)));
    public static final RegistrySupplier<Block> DARK_OAK_CHAIR = ObjectRegistry.registerWithItem("dark_oak_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> DARK_OAK_SHELF = ObjectRegistry.registerWithItem("dark_oak_shelf", () -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> DARK_OAK_BIG_TABLE = ObjectRegistry.registerWithItem("dark_oak_big_table", () -> new BigTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 2.0f)));
    public static final RegistrySupplier<Block> GRANITE_STOVE = ObjectRegistry.registerWithItem("granite_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(s -> 12)));
    public static final RegistrySupplier<Block> GRANITE_KITCHEN_SINK = ObjectRegistry.registerWithItem("granite_kitchen_sink", () -> new KitchenSinkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> GRANITE_COUNTER = ObjectRegistry.registerWithItem("granite_counter", () -> new LineConnectingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> ACACIA_CABINET = ObjectRegistry.registerWithItem("acacia_cabinet", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventsRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> ACACIA_DRAWER = ObjectRegistry.registerWithItem("acacia_drawer", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventsRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> ACACIA_TABLE = ObjectRegistry.registerWithItem("acacia_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_)));
    public static final RegistrySupplier<Block> ACACIA_CHAIR = ObjectRegistry.registerWithItem("acacia_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> ACACIA_SHELF = ObjectRegistry.registerWithItem("acacia_shelf", () -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> ACACIA_BIG_TABLE = ObjectRegistry.registerWithItem("acacia_big_table", () -> new BigTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 2.0f)));
    public static final RegistrySupplier<Block> END_STOVE = ObjectRegistry.registerWithItem("end_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(s -> 12)));
    public static final RegistrySupplier<Block> END_KITCHEN_SINK = ObjectRegistry.registerWithItem("end_kitchen_sink", () -> new KitchenSinkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> END_COUNTER = ObjectRegistry.registerWithItem("end_counter", () -> new LineConnectingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> JUNGLE_CABINET = ObjectRegistry.registerWithItem("jungle_cabinet", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventsRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> JUNGLE_DRAWER = ObjectRegistry.registerWithItem("jungle_drawer", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventsRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> JUNGLE_TABLE = ObjectRegistry.registerWithItem("jungle_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> JUNGLE_CHAIR = ObjectRegistry.registerWithItem("jungle_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> JUNGLE_SHELF = ObjectRegistry.registerWithItem("jungle_shelf", () -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> JUNGLE_BIG_TABLE = ObjectRegistry.registerWithItem("jungle_big_table", () -> new BigTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 2.0f)));
    public static final RegistrySupplier<Block> MUD_STOVE = ObjectRegistry.registerWithItem("mud_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(s -> 12)));
    public static final RegistrySupplier<Block> MUD_KITCHEN_SINK = ObjectRegistry.registerWithItem("mud_kitchen_sink", () -> new KitchenSinkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> MUD_COUNTER = ObjectRegistry.registerWithItem("mud_counter", () -> new LineConnectingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> MANGROVE_CABINET = ObjectRegistry.registerWithItem("mangrove_cabinet", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventsRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> MANGROVE_DRAWER = ObjectRegistry.registerWithItem("mangrove_drawer", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventsRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> MANGROVE_TABLE = ObjectRegistry.registerWithItem("mangrove_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> MANGROVE_CHAIR = ObjectRegistry.registerWithItem("mangrove_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> MANGROVE_SHELF = ObjectRegistry.registerWithItem("mangrove_shelf", () -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> MANGROVE_BIG_TABLE = ObjectRegistry.registerWithItem("mangrove_big_table", () -> new BigTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 2.0f)));
    public static final RegistrySupplier<Block> QUARTZ_STOVE = ObjectRegistry.registerWithItem("quartz_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(s -> 12)));
    public static final RegistrySupplier<Block> QUARTZ_KITCHEN_SINK = ObjectRegistry.registerWithItem("quartz_kitchen_sink", () -> new KitchenSinkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> QUARTZ_COUNTER = ObjectRegistry.registerWithItem("quartz_counter", () -> new FacingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> WARPED_CABINET = ObjectRegistry.registerWithItem("warped_cabinet", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventsRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> WARPED_DRAWER = ObjectRegistry.registerWithItem("warped_drawer", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventsRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> WARPED_TABLE = ObjectRegistry.registerWithItem("warped_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> WARPED_CHAIR = ObjectRegistry.registerWithItem("warped_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> WARPED_SHELF = ObjectRegistry.registerWithItem("warped_shelf", () -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> WARPED_BIG_TABLE = ObjectRegistry.registerWithItem("warped_big_table", () -> new BigTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 2.0f)));
    public static final RegistrySupplier<Block> RED_NETHER_BRICKS_STOVE = ObjectRegistry.registerWithItem("red_nether_bricks_stove", () -> new StoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60953_(s -> 12)));
    public static final RegistrySupplier<Block> RED_NETHER_BRICKS_KITCHEN_SINK = ObjectRegistry.registerWithItem("red_nether_bricks_kitchen_sink", () -> new KitchenSinkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> RED_NETHER_BRICKS_COUNTER = ObjectRegistry.registerWithItem("red_nether_bricks_counter", () -> new LineConnectingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistrySupplier<Block> CRIMSON_CABINET = ObjectRegistry.registerWithItem("crimson_cabinet", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventsRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> CRIMSON_DRAWER = ObjectRegistry.registerWithItem("crimson_drawer", () -> new StorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventsRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventsRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> CRIMSON_TABLE = ObjectRegistry.registerWithItem("crimson_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> CRIMSON_CHAIR = ObjectRegistry.registerWithItem("crimson_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> CRIMSON_SHELF = ObjectRegistry.registerWithItem("crimson_shelf", () -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> CRIMSON_BIG_TABLE = ObjectRegistry.registerWithItem("crimson_big_table", () -> new BigTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 2.0f)));
    public static final RegistrySupplier<Block> POTTED_ROSE = ObjectRegistry.registerWithoutItem("potted_rose", () -> new FlowerPotBlock((Block)ROSE.get(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50233_)));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    public static void registerArmor() {
        Registry.m_122965_((Registry)Registry.f_122827_, (ResourceLocation)new CandlelightIdentifier("cooking_hat"), (Object)((Item)COOKING_HAT.get()));
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties().m_41491_(Candlelight.CANDLELIGHT_TAB);
        consumer.accept(settings);
        return settings;
    }

    private static Item.Properties getSettingsWithoutTab(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    private static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    private static Item.Properties getSettingsWithoutTab() {
        return ObjectRegistry.getSettingsWithoutTab(settings -> {});
    }

    private static BlockBehaviour.Properties getBushSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_);
    }

    private static BlockBehaviour.Properties getLogBlockSettings() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56736_);
    }

    private static BlockBehaviour.Properties getWineSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60955_().m_60966_();
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return ObjectRegistry.registerWithItem(name, block, Candlelight.CANDLELIGHT_TAB);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block, @Nullable CreativeModeTab tab) {
        return Util.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (ResourceLocation)new CandlelightIdentifier(name), block, (CreativeModeTab)tab);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return Util.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, (ResourceLocation)new CandlelightIdentifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return Util.registerItem(ITEMS, ITEM_REGISTRAR, (ResourceLocation)new CandlelightIdentifier(path), itemSupplier);
    }
}

